REBOL [
	subject: "envoi et rception de cookies"
	version: 1.0
	author: "Olivier Auverlot"
]

cookie: make object! [

	table: charset [
		#"A" - #"Z"
		#"a" - #"z"
		#"0" - #"9"
		#"@" #"." #"*" #"-" #"_"
	]

	set: function [ name value 
		/expires datefin 
		/path chemin
		/domain domaine
		/secure
	] [ c str ] [
		str: make string! ""
		value: to-string value
		forall value [
			append str either find table first value [
				first value
			] [
				rejoin [ "%" to-string skip tail (to-hex to-integer first value) -2 ]
			]
		]
		c: copy join "Set-Cookie:" [ name "=" str ";" ]
		if expires [
			c: copy join c [ "expires=" datefin ";" ]
		]
		if path [
			c: copy join c [ "path=" chemin ";" ]
		] 
		if domain [
			c: copy join c [ "domain=" domaine ";" ]
		]
		if secure [
			c: copy join c [ " secure" ]
		]
		print c
	]

	get: function [ name ] [ c data ] [
       		c: copy select system/options/cgi/other-headers "HTTP_COOKIE"
        	data: parse c "=;"
        	dehex select data name
	]     

]

